#include <stdio.h>		/* For printf */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    int     i, status, nchan;
    FLOATSIZ64 buffer[1024];
    LONGSIZ32 count;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[2];
    SHORTSIZ16 group;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    nchan = 2;
    chan_list[0] = E1432_INPUT_CHAN(1);
    chan_list[1] = E1432_INPUT_CHAN(2);
    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    group));
	return -1;
    }

    CHECK(e1432_set_data_size(hw, group, E1432_DATA_SIZE_FLOAT32));
    CHECK(e1432_set_auto_trigger(hw, group, E1432_MANUAL_TRIGGER));
    CHECK(e1432_set_trigger_ext(hw, group, E1432_TRIGGER_EXT_NEG));
    CHECK(e1432_init_measure(hw, group));

    for ( ; ; )
    {
	/* Wait for block available */
	while ((status = e1432_block_available(hw, group)) == 0);
	if (status > 0)
	    (void) printf("Block available found!\n");
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n",
				status));
	    return -1;
	}

	/* Read some data */
	for (i = 0; i < nchan; i++)
	{
	    CHECK(e1432_read_float64_data(hw, chan_list[i],
					  E1432_TIME_DATA, buffer,
					  1024, NULL, &count));
	    if (count != 1024)
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }
	}
    }
    /*NOTREACHED*/
    return 0;
}
